// HelpAction.cpp: implementation of the CHelpAction class.
//
//////////////////////////////////////////////////////////////////////
#include "pch.h"

#include "../Common.hpp"
#include "../Log.h"
#include "../exceptions.h"
#include "../Adrenalin.h"
#include "HelpAction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHelpAction::CHelpAction(int aHelpType)
{
	helpType = aHelpType;
}


CHelpAction::~CHelpAction()
{

}


void CHelpAction::invoke() {
	switch (helpType) {
	case BRIEF_HELP:
		printBriefHelp();
		break;
	case DETAILED_HELP:
		printDetailedHelp();
		break;
	default:
		throw tstring(TEXT("Unknown help requested"));
	}
}


void CHelpAction::printBriefHelp() {
	g_vars.m_log << CLog::SetSingle(new CLog::StdOut());

	g_vars.m_log << CAdrenalin::getName().c_str() << _T(" FileEchoProcessor for Windows\n");
	g_vars.m_log << _T("Copyright (c) Andrey Kuprishov 2:5023/27@Fidonet\n");
	g_vars.m_log << _T("Usage: Adrenalin.exe [options]\n");
	g_vars.m_log << _T("where options are:\n");
	g_vars.m_log << _T("  HELP        prints detailed help on options\n");
	g_vars.m_log << _T("  FIX         scans netmail directory for filefix requests\n");
	g_vars.m_log << _T("  TOSS        scans inbound directory for TIC-files and tosses them\n");
	g_vars.m_log << _T("  TOSSBAD     scans badtics directory for TIC-files and tosses them\n");
	g_vars.m_log << _T("  PURGE       [<area mask>... -<area mask>...]\n");
	g_vars.m_log << _T("  TIMEPURGE   <hours> [<address mask>...]\n");
	g_vars.m_log << _T("  BASEPURGE   <days> [areamask]+\n");
	g_vars.m_log << _T("  HATCH       <file> <area> <desc> [-r <Replaces>] [-L]\n");
	g_vars.m_log << _T("  RELINK      <addr> [<robot name>]\n");
	g_vars.m_log << _T("  HAND        <addr> <command>+\n");
	g_vars.m_log << _T("  CHANGEGROUP (+|-)<group> <links mask>\n");

	g_vars.m_log << CLog::Pop(3);
}


void CHelpAction::printDetailedHelp() {
	g_vars.m_log << CLog::SetSingle(new CLog::StdOut());

	g_vars.m_log << CAdrenalin::getName().c_str() << _T(" FileEchoProcessor for Windows\n");
	g_vars.m_log << _T("Copyright (c) Andrey Kuprishov 2:5023/27@Fidonet\n");
	g_vars.m_log << _T("Usage: Adrenalin.exe [options]\n");
	g_vars.m_log << _T("where options are:\n");
	g_vars.m_log << _T("  HELP      prints this help information\n");
	g_vars.m_log << _T("  FIX       scans netmail directory for filefix requests\n");
	g_vars.m_log << _T("  TOSS      scans inbound directory for TIC-files and tosses them\n");
	g_vars.m_log << _T("  TOSSBAD   scans badtics directory for TIC-files and tosses them;\n");
	g_vars.m_log << _T("            files for TICs supposed to be in inbound directory\n");
	g_vars.m_log << _T("  PURGE     removes all sent files from passthrough or specified areas,\n");
	g_vars.m_log << _T("            e.g. PURGE <area mask>... -<area mask>...\n");
	g_vars.m_log << _T("  TIMEPURGE <hours> [<address mask>...]\n");
	g_vars.m_log << _T("            removes obsolete files and TICs (older than <hours> hours) from BSO\n");
	g_vars.m_log << _T("  BASEPURGE <days> [areamask]+\n");
	g_vars.m_log << _T("            removes obsolete files (older than <days> days) from fileechos\n");
	g_vars.m_log << _T("            using information from 'files.db' file\n");
	g_vars.m_log << _T("  HATCH <file> <area> <desc> [-r <Replaces>] [-L]\n");
	g_vars.m_log << _T("            hatches file into fileecho\n");
	g_vars.m_log << _T("              <file>     name of file to hatch\n");
	g_vars.m_log << _T("              <area>     fileecho area to be hatched into\n");
	g_vars.m_log << _T("              <desc>     description of file\n");
	g_vars.m_log << _T("              <Replaces> optional Replaces file name\n");
	g_vars.m_log << _T("              -L         means that file will be left without copying it into\n");
	g_vars.m_log << _T("                         the fileecho directory\n");
	g_vars.m_log << _T("  RELINK <addr> [<robot name>]\n");
	g_vars.m_log << _T("            sends relink request to the specified link using robot name as\n");
	g_vars.m_log << _T("            a receiver name (in a field TO)\n");
	g_vars.m_log << _T("            default robot name is AllFix\n");
	g_vars.m_log << _T("  HAND <addr> <command>+\n");
	g_vars.m_log << _T("            simulates filefix request from a link at <addr> address.\n");
	g_vars.m_log << _T("  CHANGEGROUP (+|-)<group> <links mask>\n");
	g_vars.m_log << _T("              changes group for links (addes or removes), example:\n");
	g_vars.m_log << _T("              changegroup +BOOK */27.*\n");
	g_vars.m_log << _T("              will add group BOOK to all my (and every /27) points\n");

	g_vars.m_log << CLog::Pop(3);
}
